/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.relics;

import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.cards.CardGroup;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.relics.AbstractRelic;
import com.megacrit.cardcrawl.unlock.UnlockTracker;
import java.util.Iterator;

public class PandorasBox
extends AbstractRelic {
    public static final String ID = "Pandora's Box";
    private int count = 0;
    private boolean calledTransform = true;

    public PandorasBox() {
        super(ID, "pandorasBox.png", AbstractRelic.RelicTier.BOSS, AbstractRelic.LandingSound.MAGICAL);
    }

    @Override
    public String getUpdatedDescription() {
        return this.DESCRIPTIONS[0];
    }

    @Override
    public void onEquip() {
        this.calledTransform = false;
        Iterator<AbstractCard> i = AbstractDungeon.player.masterDeck.group.iterator();
        while (i.hasNext()) {
            AbstractCard e = i.next();
            if (!e.cardID.equals("Strike_R") && !e.cardID.equals("Strike_G") && !e.cardID.equals("Defend_R") && !e.cardID.equals("Defend_G") && !e.cardID.equals("Defend_B")) continue;
            i.remove();
            ++this.count;
        }
        CardGroup group = new CardGroup(CardGroup.CardGroupType.UNSPECIFIED);
        for (int i2 = 0; i2 < this.count; ++i2) {
            AbstractCard card = AbstractDungeon.getCard(AbstractDungeon.rollRarity(AbstractDungeon.miscRng), AbstractDungeon.miscRng).makeStatEquivalentCopy();
            UnlockTracker.markCardAsSeen(card.cardID);
            card.isSeen = true;
            group.addToBottom(card);
        }
        AbstractDungeon.gridSelectScreen.openConfirmationGrid(group, this.DESCRIPTIONS[1]);
    }

    @Override
    public void update() {
        super.update();
        if (!this.calledTransform && AbstractDungeon.screen != AbstractDungeon.CurrentScreen.GRID) {
            this.calledTransform = true;
            AbstractDungeon.getCurrRoom().rewardPopOutTimer = 0.25f;
        }
    }

    @Override
    public AbstractRelic makeCopy() {
        return new PandorasBox();
    }
}

